/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.awt.Dimension;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MMenu;
import org.compiere.model.MRole;
import org.compiere.model.MTab;
import org.compiere.model.MWindowAccess;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Window;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.compiere.wf.MWFNode;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MWindow
extends X_AD_Window
implements ImmutablePOSupport {
    private static final long serialVersionUID = -7482290667487859946L;
    private static CLogger s_log = CLogger.getCLogger(MWindow.class);
    private static ImmutableIntPOCache<Integer, MWindow> s_cache = new ImmutableIntPOCache("AD_Window", 20, 0, false, 0);
    private MTab[] m_tabs = null;

    public static MWindow get(int AD_Window_ID) {
        return MWindow.get(Env.getCtx(), AD_Window_ID);
    }

    public static MWindow get(Properties ctx, int AD_Window_ID) {
        Integer key = AD_Window_ID;
        MWindow retValue = s_cache.get(ctx, key, e -> new MWindow(ctx, (MWindow)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MWindow(ctx, AD_Window_ID, null);
        if (retValue.get_ID() == AD_Window_ID) {
            s_cache.put(key, retValue, e -> new MWindow(Env.getCtx(), (MWindow)e));
            return retValue;
        }
        return null;
    }

    public static MWindow get(Properties ctx, String uu) {
        MWindow retValue;
        MWindow[] it;
        if (Util.isEmpty(uu, true)) {
            return null;
        }
        MWindow[] mWindowArray = it = s_cache.values().toArray(new MWindow[0]);
        int n = it.length;
        int n2 = 0;
        while (n2 < n) {
            retValue = mWindowArray[n2];
            if (uu.equals(retValue.getAD_Window_UU())) {
                return new MWindow(ctx, retValue);
            }
            ++n2;
        }
        retValue = (MWindow)new Query(ctx, "AD_Window", "AD_Window_UU=?", null).setParameters(uu).setOnlyActiveRecords(true).first();
        return retValue;
    }

    public MWindow(Properties ctx, String AD_Window_UU, String trxName) {
        super(ctx, AD_Window_UU, trxName);
        if (Util.isEmpty(AD_Window_UU)) {
            this.setInitialDefaults();
        }
    }

    public MWindow(Properties ctx, int AD_Window_ID, String trxName) {
        super(ctx, AD_Window_ID, trxName);
        if (AD_Window_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setWindowType("M");
        this.setEntityType("U");
        this.setIsBetaFunctionality(false);
        this.setIsDefault(false);
        this.setIsSOTrx(true);
    }

    public MWindow(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MWindow(MWindow copy) {
        this(Env.getCtx(), copy);
    }

    public MWindow(Properties ctx, MWindow copy) {
        this(ctx, copy, null);
    }

    public MWindow(Properties ctx, MWindow copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_tabs = copy.m_tabs != null ? (MTab[])Arrays.stream(copy.m_tabs).map(e -> new MTab(ctx, (MTab)e, trxName)).toArray(MTab[]::new) : null;
    }

    public void setWindowSize(Dimension size) {
        if (size != null) {
            this.setWinWidth(size.width);
            this.setWinHeight(size.height);
        }
    }

    public MTab[] getTabs(boolean reload, String trxName) {
        if (this.m_tabs != null && !reload) {
            return this.m_tabs;
        }
        List<MTab> list = new Query(this.getCtx(), "AD_Tab", "AD_Window_ID=?", trxName).setParameters(this.getAD_Window_ID()).setOrderBy("SeqNo").list();
        if (list.size() > 0 && this.is_Immutable()) {
            list.stream().forEach(e -> {
                MTab mTab = e.markImmutable();
            });
        }
        this.m_tabs = new MTab[list.size()];
        list.toArray(this.m_tabs);
        return this.m_tabs;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        block8: {
            block7: {
                if (!success) {
                    return success;
                }
                if (!newRecord) break block7;
                MRole[] roles = MRole.getOf(this.getCtx(), "IsManual='N'");
                int i = 0;
                while (i < roles.length) {
                    MWindowAccess wa = new MWindowAccess(this, roles[i].getAD_Role_ID());
                    wa.saveEx();
                    ++i;
                }
                break block8;
            }
            if (!this.is_ValueChanged("IsActive") && !this.is_ValueChanged("Name") && !this.is_ValueChanged("Description") && !this.is_ValueChanged("Help")) break block8;
            MMenu[] menues = MMenu.get(this.getCtx(), "AD_Window_ID=" + this.getAD_Window_ID(), this.get_TrxName());
            int i = 0;
            while (i < menues.length) {
                menues[i].setName(this.getName());
                menues[i].setDescription(this.getDescription());
                menues[i].setIsActive(this.isActive());
                menues[i].saveEx();
                ++i;
            }
            MWFNode[] nodes = MWFNode.getWFNodes(this.getCtx(), "AD_Window_ID=" + this.getAD_Window_ID(), this.get_TrxName());
            int i2 = 0;
            while (i2 < nodes.length) {
                boolean changed = false;
                if (nodes[i2].isActive() != this.isActive()) {
                    nodes[i2].setIsActive(this.isActive());
                    changed = true;
                }
                if (nodes[i2].isCentrallyMaintained()) {
                    nodes[i2].setName(this.getName());
                    nodes[i2].setDescription(this.getDescription());
                    nodes[i2].setHelp(this.getHelp());
                    changed = true;
                }
                if (changed) {
                    nodes[i2].saveEx();
                }
                ++i2;
            }
        }
        return success;
    }

    @Deprecated
    public static MWFNode[] getWFNodes(Properties ctx, String whereClause, String trxName) {
        return MWFNode.getWFNodes(ctx, whereClause, trxName);
    }

    public static int getWindow_ID(String windowName) {
        int retValue;
        block6: {
            retValue = 0;
            String SQL = "SELECT AD_Window_ID FROM AD_Window WHERE Name = ?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(SQL, null);
                    pstmt.setString(1, windowName);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, SQL, e);
                    retValue = -1;
                    DB.close(rs, pstmt);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        return retValue;
    }

    @Override
    public MWindow markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_tabs != null && this.m_tabs.length > 0) {
            Arrays.stream(this.m_tabs).forEach(e -> {
                MTab mTab = e.markImmutable();
            });
        }
        return this;
    }
}

